import { View, StyleSheet, FlatList } from "react-native";
import React from "react";
import SkeletonElement from "../../../SkeletonElement";
import { orderHistoryStyle } from "../../../../../screens/Profile/OrderHistory/OrderHistoryStyle";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";

const RenderItem = ({ item }) => (
    <View style={orderHistoryStyle.item}>
        <View style={styles.header}>
            <SkeletonElement wrapperStyle={styles.wrapperCommonStyle} />
            <SkeletonElement wrapperStyle={styles.wrapperCommonStyle} />
        </View>
        <SkeletonElement wrapperStyle={styles.skeletonWrapperStyle} />
    </View>
);

const OrderHistorySkeleton = () => {
    let x = undefined;
    return (
        <View>
            <FlatList
                data={new Array(9).fill(x)}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default OrderHistorySkeleton;

const styles = StyleSheet.create({
    header: {
        flexDirection: "row",
        justifyContent: "space-between",
        marginBottom: dpr(10),
    },
    skeletonWrapperStyle:{
        height: dpr(12),
        width: dpr("wf") - dpr(120),
    },
    wrapperCommonStyle: {
        height: dpr(20),
        width: dpr(100),
    },
});
